if exists ( select * from sys.procedures where name = 'p_consulta_produto_equiv_preco_liq' )
begin
	drop procedure p_consulta_produto_equiv_preco_liq
end
go


create or alter proc p_consulta_produto_equiv_preco_liq
(	@cd_emp int
	, @cd_filial int
	, @cd_prod  int
	, @mesma_apres  bit			-- mesma pres  ???   usa CD_APRES no join EST_PROD_EST_ARV_MERCADOLOGICA
	, @cd_conv  int   
	, @nr_cartao_fidel varchar( 50 )  
	, @ean  int  
	, @cd_cli  int    
	, @qtde_prod  int 
	, @application  int  
	, @id_promo int
	, @is_receita  int
	, @cd_frm_pgto  int
	, @cd_vend  int
	, @cd_parceiro  int
	, @tp_orig_venda  int
)


as


/*

exec p_consulta_produto_equiv_preco_liq  1 , 18 , 137448 , 0 , 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
exec p_consulta_produto_equiv_preco_liq  1 , 18 , 137448 , 1 , 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
exec p_consulta_produto_equiv_preco_liq  1 , 18 , 80584 , 0 , 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
80584

*/


set nocount off

declare @var_cd_prod  int


declare @temp_cods_produto table 
   ( cd_prod int )
	
declare @temp_rs_produto_pool table
   (
		VERSAO VARCHAR(100)
		,CD_EMP INT
		,CD_FILIAL INT
		,CD_PROD INT
		,DS_PROD VARCHAR(100)
		,NM_FABRIC VARCHAR(100)
		,VLR_TABELA MONEY
		,VLR_OFERTA MONEY
		,QTDE_PONTO_FIDEL MONEY
		,CTR_PMC INT
		,LIB_DESC_VERBA INT
		,FLAG_REQUER_RECEIT INT
		,FLAG_ALTERAR_PRECO INT
		,PROD_USO_CONT INT
		,TP_PROD INT
		,VLR_CUSTO MONEY
		,CD_GRP INT
		,QTD_PONTO_VENDA MONEY
		,LMT_PROD_PONTO_VENDA MONEY
		,APRES_QT_VD INT
		,QTDE_ESTOQUE MONEY
		,DS_TIPO_RECEITA VARCHAR(100)
		,DS_COR_RECEITA VARCHAR(100)
		,PERC_DESC_LIMITE MONEY
		,CD_TRIB_FC VARCHAR(3)
		,PERC_ICMS_N_CONT_ESTA MONEY
		,PERC_RED_VD MONEY
		,LIBERA_VD_CONV INT
		,QTDE_PROD_MAX_CONV INT
		,FIXA_DESCONTO INT
		,TP_DESCONTO INT
		,VLR_ECONOMIA MONEY
		,DS_DESCONTO VARCHAR(150)
		,CD_TBL_DESC INT
		,TP_NIVEL INT
		,PERC_DESC MONEY
		,MAIOR_PERC_DESC MONEY
		,PRODUTO_CONTROLADO INT
		,VLR_PMC MONEY	
-- AVALIAR COLUNAS ABAIXO
		,FLAG_DESCONTO_TICKET_BLQ INT
		,PERC_DESC_FIDEL_MAX MONEY
		,PROMO_INDUSTRIA INT
		,PERC_DESC_ANIVER MONEY
		,PERC_DESC_CLAS MONEY
		,VLR_DESC_FABRIC MONEY
		,CAMPANHA INT
		,QTDE_PROD_CAMPANHA INT
		,FLAG_BLOQUEIA_DESCONTO INT
		,PERC_DESC_POS_PBM DECIMAL(6, 4)
		,CD_FAMILIA INT
		,NCM_PROD VARCHAR(50)
		,NR_REG_MS VARCHAR(150)
		--,TP_TBL_DESC  INT DEFAULT ( 3 )
		)



IF ISNULL( ( SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'FLAG_TIPO_PESQUISA_EQUIVALENCIA' ) ,  0 ) = 0  
BEGIN 

INSERT INTO @temp_cods_produto
--declare @cd_emp int = 1 , @cd_filial int = 18 , @cd_prod  int = 137448
SELECT 
		PROD.CD_PROD
	FROM EST_PROD AS PROD 
	JOIN EST_PROD_PRINC_ATIVOS_EST_PROD AS PRIN_ATIVO_RET 
		ON PROD.CD_EMP = PRIN_ATIVO_RET.CD_EMP
		AND PROD.CD_PROD = PRIN_ATIVO_RET.CD_PROD 
	JOIN EST_PROD_PRINC_ATIVOS AS PRIN_ATIVO 
		ON PRIN_ATIVO_RET.CD_PRINC_ATIVOS = PRIN_ATIVO.CD_PRINC_ATIVOS 
	JOIN EST_PROD_PRINC_ATIVOS_EST_PROD AS PRIN_ATIVO_PROD_CONS 
		ON PRIN_ATIVO.CD_PRINC_ATIVOS = PRIN_ATIVO_PROD_CONS.CD_PRINC_ATIVOS 
		AND PRIN_ATIVO_PROD_CONS.CD_PROD <> PRIN_ATIVO_RET.CD_PROD 
	JOIN EST_PROD_CPL AS PROD_CPL 
		ON PROD.CD_EMP = PROD_CPL.CD_EMP
		AND PROD.CD_PROD = PROD_CPL.CD_PROD 
	JOIN EST_PROD_PRECO AS PRECO 
		ON PROD_CPL.CD_EMP = PRECO.CD_EMP 
		AND PROD_CPL.CD_FILIAL = PRECO.CD_FILIAL 
		AND PROD_CPL.CD_PROD = PRECO.CD_PROD 
	JOIN EST_PROD_FABRIC AS PROD_FABRIC 
		ON PROD.CD_FABRIC = PROD_FABRIC.CD_FABRIC 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS PROD_ARV_MERC 
		ON PROD.CD_EMP = PROD_ARV_MERC.CD_EMP  
		AND PROD.CD_PROD = PROD_ARV_MERC.CD_PROD 
	JOIN EST_ARV_MERC_LINHA 
		ON PROD_ARV_MERC.CD_ARV_MERC_LINHA = EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA 
		AND PROD_ARV_MERC.CD_EMP = EST_ARV_MERC_LINHA.CD_EMP  
	WHERE PRIN_ATIVO_PROD_CONS.CD_PROD = @cd_prod 
		AND PROD_CPL.CD_FILIAL = @cd_filial
		AND PROD.CD_EMP = @cd_emp
		AND PROD.STS_PROD in ( 0 , 2 )
		AND PROD_CPL.TP_PROD IN (0,9,10,11)
		AND PROD.STS_PROD_CALL_CENTER = 0

END ELSE
BEGIN

INSERT INTO @temp_cods_produto
SELECT 
		EP_RETORNO.CD_PROD
	FROM EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_RETORNO 
	JOIN EST_PROD AS EP_RETORNO ON EPEAM_RETORNO.CD_EMP = EP_RETORNO.CD_EMP AND EPEAM_RETORNO.CD_PROD = EP_RETORNO.CD_PROD 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_CONS 
		ON EPEAM_RETORNO.CD_EMP = EPEAM_CONS.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EPEAM_CONS.CD_ARV_MERC_EQUI 
		AND ( @mesma_apres = 0 OR ( @mesma_apres = 1 and  EPEAM_RETORNO.CD_APRES = EPEAM_CONS.CD_APRES  ) )
	JOIN EST_PROD AS EP_CONS 
		ON EPEAM_CONS.CD_EMP = EP_CONS.CD_EMP 
		AND EPEAM_CONS.CD_PROD = EP_CONS.CD_PROD  
		AND EPEAM_CONS.CD_APRES > 0
		AND EPEAM_CONS.CD_ARV_MERC_EQUI > 0 
		AND EP_RETORNO.CD_PROD <> EP_CONS.CD_PROD 
	JOIN EST_PROD_CPL AS EPL 
		ON EP_RETORNO.CD_EMP = EPL.CD_EMP 
		AND EP_RETORNO.CD_PROD = EPL.CD_PROD 
	JOIN EST_PROD_PRECO AS EPP 
		ON EPL.CD_EMP = EPP.CD_EMP 
		AND EPL.CD_FILIAL = EPP.CD_FILIAL 
		AND EPL.CD_PROD = EPP.CD_PROD 
	JOIN EST_ARV_MERC_EQUIVALENTE AS EAME 
		ON EPEAM_RETORNO.CD_EMP = EAME.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EAME.CD_ARV_MERC_EQUI 
	JOIN EST_ARV_MERC_APRESENTACAO AS EAMA 
		ON EPEAM_RETORNO.CD_EMP = EAMA.CD_EMP 
		AND EPEAM_RETORNO.CD_APRES = EAMA.CD_APRES 
	JOIN EST_PROD_FABRIC AS EPF 
		ON EP_RETORNO.CD_FABRIC = EPF.CD_FABRIC 
	JOIN EST_ARV_MERC_LINHA AS EAML 
		ON EPEAM_RETORNO.CD_EMP = EAML.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_LINHA = EAML.CD_ARV_MERC_LINHA 
	WHERE EPL.CD_FILIAL = @cd_filial AND EP_CONS.CD_PROD = @cd_prod   
		AND EP_RETORNO.CD_EMP = 1
		AND EP_RETORNO.STS_PROD in ( 0 , 2 )
		AND EPL.TP_PROD IN (0,9,10,11)
		AND EP_RETORNO.STS_PROD_CALL_CENTER = 0

END


while exists (  select top 1 1 from @temp_cods_produto order by cd_prod )  
begin

   set @var_cd_prod = (select top 1 cd_prod from @temp_cods_produto order by cd_prod )

   insert into @temp_rs_produto_pool
   EXEC P_EST_PROD_DESCONTOS
         @CD_EMP  = @cd_emp
         , @CD_FILIAL  = @cd_filial
         , @CD_PROD   = @var_cd_prod
         , @CD_CONV   = @cd_conv
         , @NR_CARTAO_FIDEL = @nr_cartao_fidel
         , @EAN    = @ean
         , @CD_CLI  = @cd_cli
         , @QTDE_PROD    = @qtde_prod
         , @APPLICATION  = @application
         , @ID_PROMO    = @id_promo
         , @IS_RECEITA  =  @is_receita
         , @CD_FRM_PGTO  = @cd_frm_pgto
         , @IGNORED   = 0
         , @CD_VEND   = @cd_vend
         , @CD_PARCEIRO  = @cd_parceiro
         , @TP_ORIG_VENDA  = @tp_orig_venda

   delete from @temp_cods_produto
      where cd_prod = @var_cd_prod

end


IF ISNULL( ( SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'FLAG_TIPO_PESQUISA_EQUIVALENCIA' ) ,  0 ) = 0  
BEGIN 


SELECT  DISTINCT
		PROD.CD_PROD, PROD.DS_PROD, PRECO.VLR_TABELA ,
		CONVERT( DECIMAL( 12 ,2 ) , COALESCE(PRECO.VLR_TABELA,0.00)
							- (COALESCE(PRECO.VLR_TABELA,0.00)*(t.PERC_DESC/100.00) ) ) as VLR_LIQUIDO, 
		'' AS DS_APRES, PRIN_ATIVO.DS_PRINC_ATIVOS AS DS_ARV_MERC_EQUI, PROD_CPL.QT_EST, 
		PROD_FABRIC.NM_FABRIC, EST_ARV_MERC_LINHA.DS_SIGLA_LINHA             , 
		(SELECT CASE ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'CTR_CUSTO_SEMAFORO'),0) WHEN 0 THEN VLR_CUSTO ELSE VLR_CUSTO_MD END    
			FROM EST_PROD_CPL   
			WHERE CD_EMP = 1 
				AND CD_FILIAL = @CD_FILIAL  
				AND CD_PROD = PROD.CD_PROD) AS VLR_CUSTO 
	FROM @temp_rs_produto_pool  t	 
	JOIN EST_PROD AS PROD 
		ON PROD.CD_EMP  = t.CD_EMP
		AND PROD.CD_PROD = t.CD_PROD
	JOIN EST_PROD_PRINC_ATIVOS_EST_PROD AS PRIN_ATIVO_RET 
		ON PROD.CD_EMP = PRIN_ATIVO_RET.CD_EMP
		AND PROD.CD_PROD = PRIN_ATIVO_RET.CD_PROD 
	JOIN EST_PROD_PRINC_ATIVOS AS PRIN_ATIVO 
		ON PRIN_ATIVO_RET.CD_PRINC_ATIVOS = PRIN_ATIVO.CD_PRINC_ATIVOS 
	JOIN EST_PROD_CPL AS PROD_CPL 
		ON PROD.CD_EMP = PROD_CPL.CD_EMP
		AND t.CD_FILIAL = PROD_CPL.CD_FILIAL
		AND PROD.CD_PROD = PROD_CPL.CD_PROD 
	JOIN EST_PROD_PRECO AS PRECO 
		ON PROD_CPL.CD_EMP = PRECO.CD_EMP 
		AND PROD_CPL.CD_FILIAL = PRECO.CD_FILIAL 
		AND PROD_CPL.CD_PROD = PRECO.CD_PROD 
	JOIN EST_PROD_FABRIC AS PROD_FABRIC 
		ON PROD.CD_FABRIC = PROD_FABRIC.CD_FABRIC 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS PROD_ARV_MERC 
		ON PROD.CD_EMP = PROD_ARV_MERC.CD_EMP  
		AND PROD.CD_PROD = PROD_ARV_MERC.CD_PROD 
	JOIN EST_ARV_MERC_LINHA 
		ON PROD_ARV_MERC.CD_ARV_MERC_LINHA = EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA 
		AND PROD_ARV_MERC.CD_EMP = EST_ARV_MERC_LINHA.CD_EMP  

END ELSE
BEGIN

SELECT DISTINCT
		EP_RETORNO.CD_PROD, EP_RETORNO.DS_PROD, EPP.VLR_TABELA, 
		CONVERT( DECIMAL( 12 ,2 ) , COALESCE(EPP.VLR_TABELA,0.00)
							- (COALESCE(EPP.VLR_TABELA,0.00)*(t.PERC_DESC/100.00) ) ) as VLR_LIQUIDO,
		EAMA.DS_APRES, EAME.DS_ARV_MERC_EQUI, EPL.QT_EST, 
		EPF.NM_FABRIC, EAML.DS_SIGLA_LINHA             , 
		(SELECT CASE ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'CTR_CUSTO_SEMAFORO'),0) WHEN 0 THEN VLR_CUSTO ELSE VLR_CUSTO_MD END    
			FROM EST_PROD_CPL   
			WHERE CD_EMP = 1 
				AND CD_FILIAL = @CD_FILIAL  
				AND CD_PROD = EP_RETORNO.CD_PROD) AS VLR_CUSTO 
	FROM @temp_rs_produto_pool  t	 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_RETORNO 
		ON EPEAM_RETORNO.CD_EMP  = t.CD_EMP
		AND EPEAM_RETORNO.CD_PROD = t.CD_PROD
	JOIN EST_PROD AS EP_RETORNO 
		ON EPEAM_RETORNO.CD_EMP = EP_RETORNO.CD_EMP 
		AND EPEAM_RETORNO.CD_PROD = EP_RETORNO.CD_PROD 
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_CONS 
		ON EPEAM_RETORNO.CD_EMP = EPEAM_CONS.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EPEAM_CONS.CD_ARV_MERC_EQUI 
		AND ( @mesma_apres = 0 OR ( @mesma_apres = 1 and  EPEAM_RETORNO.CD_APRES = EPEAM_CONS.CD_APRES  ) )
	--JOIN EST_PROD AS EP_CONS 
	--	ON EPEAM_CONS.CD_EMP = EP_CONS.CD_EMP 
	--	AND EPEAM_CONS.CD_PROD = EP_CONS.CD_PROD  
	--	AND EPEAM_CONS.CD_APRES > 0
	--	AND EPEAM_CONS.CD_ARV_MERC_EQUI > 0 
	--	AND EP_RETORNO.CD_PROD <> EP_CONS.CD_PROD 
	JOIN EST_PROD_CPL AS EPL 
		ON EP_RETORNO.CD_EMP = EPL.CD_EMP 
		AND t.CD_FILIAL = EPL.CD_FILIAL
		AND EP_RETORNO.CD_PROD = EPL.CD_PROD 
	JOIN EST_PROD_PRECO AS EPP 
		ON EPL.CD_EMP = EPP.CD_EMP 
		AND EPL.CD_FILIAL = EPP.CD_FILIAL 
		AND EPL.CD_PROD = EPP.CD_PROD 
	JOIN EST_ARV_MERC_EQUIVALENTE AS EAME 
		ON EPEAM_RETORNO.CD_EMP = EAME.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EAME.CD_ARV_MERC_EQUI 
	JOIN EST_ARV_MERC_APRESENTACAO AS EAMA 
		ON EPEAM_RETORNO.CD_EMP = EAMA.CD_EMP 
		AND EPEAM_RETORNO.CD_APRES = EAMA.CD_APRES 
	JOIN EST_PROD_FABRIC AS EPF 
		ON EP_RETORNO.CD_FABRIC = EPF.CD_FABRIC 
	JOIN EST_ARV_MERC_LINHA AS EAML 
		ON EPEAM_RETORNO.CD_EMP = EAML.CD_EMP 
		AND EPEAM_RETORNO.CD_ARV_MERC_LINHA = EAML.CD_ARV_MERC_LINHA 

END


--fim
go